<?php
/* Copyright (C) 2007-2011 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2024		Frédéric France			<frederic.france@free.fr>
 * Copyright (C) 2024		MDW							<mdeweerd@users.noreply.github.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 * or see https://www.gnu.org/
 */

/**
 *		\file       htdocs/core/modules/security/captcha/modules_captcha.php
 *		\ingroup    core
 *		\brief      File with parent class for captcha generating classes
 */
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions.lib.php';


/**
 *  Parent class for password rules/management modules
 */
abstract class ModeleCaptcha
{
	/**
	 * @var string
	 */
	public $id;

	/**
	 * @var string
	 */
	public $version;

	/**
	 * @var string
	 */
	public $picto = 'generic';

	/**
	 * @var string Error code (or message)
	 */
	public $error = '';

	/**
	 * @var DoliDB Database handler.
	 */
	public $db;

	/**
	 * @var Conf dolibarr conf
	 */
	public $conf;

	/**
	 * @var Translate Translate Object
	 */
	public $langs;

	/**
	 * @var User user
	 */
	public $user;


	/**
	 * 		Return if a module can be used or not
	 *
	 *      @return		boolean     true if module can be used
	 */
	public function isEnabled()
	{
		return true;
	}


	/**
	 *		Return description of module
	 *
	 *      @return     string      Description of module
	 */
	public function getDescription()
	{
		global $langs;
		return $langs->trans("NoDescription");
	}

	/**
	 *  Return an example of password generated by this module
	 *
	 *  @return     string      	Example of captcha
	 */
	public function getExample()
	{
		global $langs;
		$langs->load("bills");
		return $langs->trans("NoExample");
	}

	/**
	 * 	Return the HTML content to output on a form that need the captcha
	 *
	 *  @param		string	$php_self	An URL for the a href link
	 *  @return     string				The HTML code to output
	 */
	public function getCaptchaCodeForForm($php_self = '')
	{
		return '';
	}

	/**
	 * 	Validate a captcha
	 * 	This function is called after a log to validate a captcha, before validating a password.
	 *
	 *  @return     int					0 if KO, >0 if OK
	 */
	public function validateCodeAfterLoginSubmit()
	{
		return 1;
	}
}
